// GMSH script to generate the mesh for the 3d printing filament
// Documentation: https://gmsh.info/doc/texinfo/gmsh.html
// Author: Andrea Pavan
// Date: 09/01/2023


//parameters
l1 = 0.55e-3;		//x domain size (extrusion width)
l2 = 0.2e-3;		//y domain size (layer height)
l3 = 1e-3;		//z domain size (extrusion length)

surfaceMeshSize = 0.02e-3;		//mesh size at the boundaries


//change geometry kernel
SetFactory("OpenCASCADE");


//-----------------------
//  geometry creation
//-----------------------

Point(1) = {(l1-l2)/2, l2/2, 0, surfaceMeshSize};
Point(2) = {(l1-l2)/2, 0, 0, surfaceMeshSize};
Point(3) = {(l1-l2)/2, -l2/2, 0, surfaceMeshSize};
Point(4) = {-(l1-l2)/2, -l2/2, 0, surfaceMeshSize};
Point(5) = {-(l1-l2)/2, 0, 0, surfaceMeshSize};
Point(6) = {-(l1-l2)/2, l2/2, 0, surfaceMeshSize};

Circle(1) = {1, 2, 3};
Line(2) = {3, 4};
Circle(3) = {4, 5, 6};
Line(4) = {6, 1};

Curve Loop(1) = {1, 2, 3, 4};
Plane Surface(1) = {1};
Extrude {0, 0, l3} {
  Curve{1}; Curve{2}; Curve{3}; Curve{4}; 
}
Curve Loop(6) = {7, 9, 11, 12};
Plane Surface(6) = {6};
Surface Loop(1) = {5, 4, 3, 2, 6, 1};
Volume(1) = {1};
